
# EE367 Winter 2025 Final Project Source Code

Author: Jack Irish, Stanford University

Contact: jirish42@stanford.edu


## Project Code
* EE367_SE.ipynb is a Jupyter notebook containing all code used to train models and collect data used in this project
* See notebook for additional comments and instructions 
* The notebook is designed to be run out of the box in a Google Colab environment
* The only libraries installed in addition to Colab defaults are torchmetrics, bm3d, pystoi and pesq
    * torchmetrics, pystoi and pesq are used to compute the SDR, STOI and PESQ objective speech metrics
    * bm3d is a Python wrapper for the BM3D algorithm. For credit, see developer homepage at https://webpages.tuni.fi/foi/GCF-BM3D/
* generate_plots.m is a Matlab script used to generate the two SDR comparison plots shown in the report and poster

## Directory Structure
* This project is built around a Google Colab compute environment, so it relies on a specific Google Drive directory structure
* The top-level directory, named 'EE367' by default, must be specified in the first cell when mounting your Drive to the Colab instance
* Underneath the top-level directory, the Drive must contain the 'MS-SNSD' directory and all subdirectories included with this source code
* MS-SNSD generated clean speech files from the repo's CleanSpeech_training directory should be uploaded to 'MS-SNSD/dataset/CleanSpeech' and noisy speech files from the repo's NoisySpeech_training directory should be uploaded to 'MS-SNSD/dataset/NoisySpeech' with file names unchanged
* A sample pretrained R-CED model is included under the 'models' subdirectory
## MS-SNSD Dataset
* The MS-SNSD dataset used in this project is publicly available at https://github.com/microsoft/MS-SNSD
* Instructions for generating data are included in the MS-SNSD repo
